//========================================================================
//   "SliderPuzzle" JavaScript Slider Puzzle
//
//   Copyright (C) 2000,2003  Jan Mulder
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version, and as long as this notice is
//   kept unmodified at the top of the JavaScript source code.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License (license.txt) for more details.
//
//   Contact: http://janmulder.com/contact/
//
//=======================================================================


//////////////////////////////////////////////////////////////////////////
// missingImage is the image that was taken out at the start of the game.
var missingImage = sliderImages[blankIndex-1];

////////////////////////////////////////////
// Number of rows and columns in the puzzle
var numRows, numCols;

///////////////////////////////////////////////////
// Keep a record of the where the blank square is.
var blankPos = -1;

var gameLoaded = false;
arrCorrect = new Array();  // Contains the correct image positions.
arrShuffled = new Array(); // Contains the shuffled image positions.

//////////////////////////////////////////////
// A valid move is left right up or down only
function isValidMove(ID) {
  var nID = parseInt(ID);
  var nBlankPos = parseInt(blankPos);    
  var newRow = Math.floor(nID/numRows)+1;
  var newCol = (nID%numCols)+1;
  var oldRow = Math.floor(nBlankPos/numRows)+1;
  var oldCol = (nBlankPos%numCols)+1;
  if  ( (oldRow + 1 == newRow && oldCol == newCol) || 
        (oldRow - 1 == newRow && oldCol == newCol) || 
        (oldCol + 1 == newCol && oldRow == newRow) || 
        (oldCol - 1 == newCol && oldRow == newRow) ) 
    return true;
  else
    return false;  
}    

function move(ID) {
  if (isValidMove(ID)) {
    document.images['box' + blankPos].src = document.images['box' + ID].src;
    document.images['box' + ID].src = blankImage;
    blankPos = ID;
    if (checkPuzzle(ID)) {
      document.images['box' + ID].src = missingImage;
      if (confirm('Well done. Do you want to play again?')) {
        document.images['box' + ID].src = blankImage;
        shuffleImages();
      }
    }
  }
}

function randomizeArray( arrSrc ) {
  var arrOut = new Array();
  var arrIn = new Array();  
  for (var i = 0; i < arrSrc.length; i++) {
    arrOut[arrOut.length] = null; 
    arrIn[arrIn.length] = arrSrc[i]; 
  }  
  for (var i = 0; i < arrIn.length; i++) {
    while (arrOut[i.toString()] == null) {
      var rand = Math.round(Math.random()*(arrIn.length - 1));
      if (arrIn[rand] != null) {
        arrOut[i.toString()] = arrIn[rand];
        arrIn[rand] = null;
      }
    }
  }
  return arrOut;
}    

function shuffleImages() {
  if (gameLoaded == true) {
    arrShuffled = randomizeArray(arrCorrect);
    for (var i = 0; i < sliderImages.length; i++) {
      document.images['box' + i].src = arrShuffled[i.toString()];
      if (arrShuffled[i.toString()].lastIndexOf(blankImage) != -1) {
         blankPos = i;
      }    
    }
  }
  else {
    alert('Please wait till the game has loaded.');
  }
}

function checkPuzzle(ID) {
  var fDone = true;
  for (var i = 0; i < sliderImages.length; i++) {
    if(document.images['box' + i].src != arrCorrect[i])
      fDone = false;
  }
  return fDone;
}

function initPuzzle() {
  for (var i = 0; i < sliderImages.length; i++) {
    arrCorrect[i] = document.images['box' + i].src;
  }
  gameLoaded = true;
}

function drawSlider( rows, cols ) {
 numRows = rows;
 numCols = cols;   
 
 if (rows*cols != sliderImages.length) {
   alert("Error encountered. Incorrect puzzle dimensions.");
   return; 
 }   

 var imageIndex = 0;   
 document.write("<TABLE cellSpacing=0 cellPadding=0 align=center border=0><TBODY>");
 for (i = 0; i < rows; i++)
 {
  document.write('<tr>');
  for (j = 0; j < cols; j++) {
    if ((i == rows-1) && (j == cols-1)) {
      document.write(
      "<TD><A href=\"javascript:move('" + imageIndex + "')\" onfocus=\"if (document.all) this.blur()\">"
      + "<IMG src=\"" + "blank.jpg" 
      + "\" border=0 name=box" + imageIndex + "></A></TD>\n"
      );
    }  
    else
      document.write(
      "<TD><A href=\"javascript:move('" + imageIndex + "')\" onfocus=\"if (document.all) this.blur()\">"
      + "<IMG src=\"" + sliderImages[imageIndex] 
      + "\" border=0 name=box" + imageIndex + "></A></TD>\n"
      );
      
    imageIndex++;
  }  
  document.write('</tr>\n');
 } 
 document.write("</TBODY></TABLE>\n");

}

